package misc;

import java.util.Random;

import jade.core.Agent;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.lang.acl.ACLMessage;

@SuppressWarnings("deprecation")
public class MessageUtils {

	public static Random rand = new Random();
	
	public static boolean send(Agent sender, String content) {
		
		DFAgentDescription template = new DFAgentDescription();
		ServiceDescription sd = new ServiceDescription();
		sd.setType("Person");
		template.addServices(sd);
		
		try {
			DFAgentDescription[] humans = DFService.search(sender, template);
			for (DFAgentDescription human: humans) {
				ACLMessage reply = new ACLMessage();
				reply.addReceiver(human.getName());
				reply.setPerformative(ACLMessage.INFORM);
				reply.setContent(content);
				sender.send(reply);
			}
		} catch (FIPAException e1) {
			e1.printStackTrace();
			return false;
		}
		return true;
	}
	
	public static boolean sendRandom(Agent sender, String content) {
		
		DFAgentDescription template = new DFAgentDescription();
		ServiceDescription sd = new ServiceDescription();
		sd.setType("Person");
		template.addServices(sd);
		
		try {
			DFAgentDescription[] humans = DFService.search(sender, template);
			if (humans.length == 0) return false;
			DFAgentDescription human = humans[random(humans.length)];
			ACLMessage reply = new ACLMessage();
			reply.addReceiver(human.getName());
			reply.setPerformative(ACLMessage.INFORM);
			reply.setContent(content);
			sender.send(reply);
			
		} catch (FIPAException e1) {
			e1.printStackTrace();
			return false;
		}
		return true;
	}
	
	public static int random(int max) {
		return rand.nextInt(max);
	}
}
